/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import org.w3c.dom.Node;

public class VWImportExportOptions {
    private static final String NAMESPACE = "http://filenet.com/vw/api/configuration/importexport/schema/1.0";
    private static final String ROOT = "PEImportExportOptions";
    private static final String ATTR_INCLUDE_SYSTEM_ADMIN = "includeSystemAdministration";
    private static final String ATTR_INCLUDE_USER_INFO = "includeUserInfo";
    private static final String ATTR_INCLUDE_REGION_PROPERTIES = "includeRegionProperties";
    private static final String ELEM_INCLUDE_QUEUE = "includeQueue";
    private static final String ELEM_INCLUDE_ROSTER = "includeRoster";
    private static final String ELEM_INCLUDE_LOG = "includeLog";
    private static final String ELEM_INCLUDE_APPSPACE = "includeApplicationSpace";
    private static final String ATTR_NAME = "name";
    private static final String ELEM_PEIMPORT = "PEImport";
    private static final String ATTR_CONFLICT_RESOLVE = "conflictResolve";
    public static final int OVERWRITE = 1;
    public static final int MERGE = 2;
    private static final String[] CONFLICT_RESOVLE_STR = new String[]{"undefined", "overwrite", "merge"};
    public static final int QUEUE = 0;
    public static final int ROSTER = 1;
    public static final int LOG = 2;
    public static final int APPLICATION_SPACE = 3;
    private static final String[] INCLUDE_NODE_NAMES = new String[]{"includeQueue", "includeRoster", "includeLog", "includeApplicationSpace"};
    private static final String[] ARRAY_OF_NAMES = new String[]{"ArrayOfQueueDefinition", "ArrayOfRosterDefinition", "ArrayOfLogDefinition", "ArrayOfApplicationSpaceDefinition"};
    private static final String[] NODE_NAMES = new String[]{"QueueDefinition", "RosterDefinition", "LogDefinition", "ApplicationSpaceDefinition"};
    private String fileName;
    boolean isReading;
    private VWXMLWrapper m_vwXMLWrapper;
    private Node m_rootNode;

    public String getArrayOfNodeNameInSystemConfiguration(int type) {
        return ARRAY_OF_NAMES[type];
    }

    public String getNodeNameInSystemConfiguration(int type) {
        return NODE_NAMES[type];
    }

    public static VWImportExportOptions Generate(String fileName) throws Exception {
        return new VWImportExportOptions(fileName, false);
    }

    public static VWImportExportOptions Read(String fileName) throws Exception {
        return new VWImportExportOptions(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VWImportExportOptions(String fileName, boolean isReading) throws Exception {
        block7: {
            this.isReading = false;
            this.m_vwXMLWrapper = null;
            this.m_rootNode = null;
            this.fileName = fileName;
            this.isReading = isReading;
            if (isReading) {
                FileInputStream inStream = null;
                try {
                    inStream = new FileInputStream(fileName);
                    this.m_vwXMLWrapper = new VWXMLWrapper(inStream);
                    Object var5_4 = null;
                    if (inStream == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (inStream == null) throw throwable;
                    try {
                        inStream.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception e) {}
                inStream.close();
            } else {
                this.m_vwXMLWrapper = new VWXMLWrapper(ROOT, NAMESPACE);
            }
        }
        this.m_rootNode = this.m_vwXMLWrapper.getRootNode();
        this.setImportConflictResolve(2);
    }

    public void setIncludeSystemAdministration(boolean b) {
        this.m_vwXMLWrapper.setNodeAttribute(this.m_rootNode, ATTR_INCLUDE_SYSTEM_ADMIN, b ? "true" : "false");
    }

    public boolean getIncludeSystemAdministration() {
        String bValue = VWXMLWrapper.getNodeAttribute(this.m_rootNode, ATTR_INCLUDE_SYSTEM_ADMIN);
        if (bValue != null) {
            return new Boolean(bValue);
        }
        return false;
    }

    public void setIncludeUserInfo(boolean b) {
        this.m_vwXMLWrapper.setNodeAttribute(this.m_rootNode, ATTR_INCLUDE_USER_INFO, b ? "true" : "false");
    }

    public boolean getIncludeUserInfo() {
        String bValue = VWXMLWrapper.getNodeAttribute(this.m_rootNode, ATTR_INCLUDE_USER_INFO);
        if (bValue != null) {
            return new Boolean(bValue);
        }
        return false;
    }

    public void setIncludeRegionProperties(boolean b) {
        this.m_vwXMLWrapper.setNodeAttribute(this.m_rootNode, ATTR_INCLUDE_REGION_PROPERTIES, b ? "true" : "false");
    }

    public boolean getIncludeRegionProperties() {
        String bValue = VWXMLWrapper.getNodeAttribute(this.m_rootNode, ATTR_INCLUDE_REGION_PROPERTIES);
        if (bValue != null) {
            return new Boolean(bValue);
        }
        return true;
    }

    public void setInclude(int oType, String name) throws IllegalArgumentException {
        if (oType >= INCLUDE_NODE_NAMES.length || oType < 0) {
            throw new IllegalArgumentException("Invalid includeXXX option");
        }
        Node[] nNames = VWXMLWrapper.getNodesNamed(this.m_rootNode, INCLUDE_NODE_NAMES[oType]);
        int nNodes = nNames == null ? 0 : nNames.length;
        for (int i = 0; i < nNodes; ++i) {
            String nodeName = VWXMLWrapper.getNodeAttribute(nNames[i], ATTR_NAME);
            if (nodeName == null || !nodeName.equals(name)) continue;
            return;
        }
        Node n = this.m_vwXMLWrapper.createNodeNamed(this.m_rootNode, INCLUDE_NODE_NAMES[oType], null);
        this.m_vwXMLWrapper.setNodeAttribute(n, ATTR_NAME, name);
    }

    public int getImportConflictResult() {
        Node peImport = VWXMLWrapper.getNodeNamed(this.m_rootNode, ELEM_PEIMPORT);
        if (peImport == null) {
            return 1;
        }
        String s = VWXMLWrapper.getNodeAttribute(peImport, ATTR_CONFLICT_RESOLVE);
        for (int i = 0; i < CONFLICT_RESOVLE_STR.length; ++i) {
            if (!s.equals(CONFLICT_RESOVLE_STR[i])) continue;
            return i;
        }
        return 1;
    }

    public void setImportConflictResolve(int option) throws IllegalArgumentException {
        if (option < 1 || option >= CONFLICT_RESOVLE_STR.length) {
            throw new IllegalArgumentException("Invalid includeXXX option");
        }
        Node peImport = VWXMLWrapper.getNodeNamed(this.m_rootNode, ELEM_PEIMPORT);
        if (peImport == null) {
            peImport = this.m_vwXMLWrapper.createNodeNamed(this.m_rootNode, ELEM_PEIMPORT, null);
        }
        this.m_vwXMLWrapper.setNodeAttribute(peImport, ATTR_CONFLICT_RESOLVE, CONFLICT_RESOVLE_STR[option]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush() throws Exception {
        String contents = this.m_vwXMLWrapper.toXML(this.m_rootNode);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName, false), "UTF-8"));
            writer.println(contents);
            Object var4_3 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            writer.close();
            return;
        }
        catch (Exception e) {}
    }

    public String[] getIncludeNames(int oType) throws IllegalArgumentException {
        if (oType >= INCLUDE_NODE_NAMES.length || oType < 0) {
            throw new IllegalArgumentException("Invalid includeXXX option");
        }
        Vector v = new Vector();
        VWXMLWrapper.getAllNodesNamed(this.m_rootNode, NAMESPACE, INCLUDE_NODE_NAMES[oType], v);
        int nItems = v.size();
        if (nItems == 0) {
            return null;
        }
        String[] res = new String[nItems];
        for (int i = 0; i < nItems; ++i) {
            Node n = (Node)v.get(i);
            String s = VWXMLWrapper.getNodeAttribute(n, ATTR_NAME);
            if (s != null && s.equals("*")) {
                return new String[]{"*"};
            }
            if (s == null) {
                throw new IllegalArgumentException("Invalid option=" + INCLUDE_NODE_NAMES[oType]);
            }
            res[i] = s;
        }
        return res;
    }

    private static void printUsage() {
        System.out.println("/fileName=XYZ [/writing]");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.help()) {
                VWImportExportOptions.printUsage();
            }
            boolean isWriting = c.isPresent("writing");
            String fileName = c.getParameter("fileName");
            if (fileName == null) {
                VWImportExportOptions.printUsage();
            }
            if (isWriting) {
                VWImportExportOptions options = VWImportExportOptions.Generate(fileName);
                options.setIncludeSystemAdministration(false);
                options.setIncludeUserInfo(true);
                options.setIncludeRegionProperties(true);
                options.setInclude(0, "*");
                options.setInclude(1, "*");
                options.setInclude(3, "*");
                options.setImportConflictResolve(2);
                options.flush();
            } else {
                VWImportExportOptions options = VWImportExportOptions.Read(fileName);
                System.out.println("includeSystemAdmin = " + options.getIncludeSystemAdministration());
                System.out.println("includeUserInfo = " + options.getIncludeUserInfo());
                System.out.println("includeRegionProperties = " + options.getIncludeRegionProperties());
                String[] queues = options.getIncludeNames(0);
                System.out.println("Queues = " + (queues == null ? "NONE" : Logger.asString(queues)));
                String[] rosters = options.getIncludeNames(1);
                System.out.println("Rosters = " + (rosters == null ? "NONE" : Logger.asString(rosters)));
                String[] logs = options.getIncludeNames(2);
                System.out.println("Logs = " + (logs == null ? "NONE" : Logger.asString(logs)));
                String[] appSpaces = options.getIncludeNames(3);
                System.out.println("AppSpaces = " + (appSpaces == null ? "NONE" : Logger.asString(appSpaces)));
                System.out.println("PEImport conflictResolve=" + options.getImportConflictResult());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

